// config: norepeat noautolaunch

#include "GetObjects.js"
#include "WaitForDialogDone.js"

function DoMake2D()
{
	var ui = moi.ui;

	var objectpicker = ui.createObjectPicker();
	objectpicker.allowBReps();
	objectpicker.allowCurves();
	objectpicker.allowPointObjects();
	objectpicker.allowAnnotations();
	if ( !GetObjects( objectpicker ) )
		return;

	ui.beginUIUpdate();
	ui.hideUI( 'SelectObjectsPrompt' );
	ui.showUI( 'OptionsPrompt' );
	ui.showUI( 'Make2DOptions' );
	ui.endUIUpdate();
	
	if ( !WaitForDialogDone() )
		return;

	var factory = moi.command.createFactory( 'make2d' );
	factory.setInput( 0, objectpicker.objects );
	factory.setInput( 1, ui.commandUI.view.value );
	factory.setInput( 2, ui.commandUI.resolution.value );
	factory.setInput( 3, ui.commandUI.hiddenlines.value );
	
	factory.commit();
}

DoMake2D();
